<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class ListAllByPath extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        $path = is_string($request->query('path')) ? $request->query('path') : '';
        $json = is_string($request->query('filters')) ? $request->query('filters') : '{}';

        if (! $path) {
            return new JsonResponse([]);
        }

        $filters = json_decode($json, true) ?? [];

        return response()->json(
            InsidePagesService::listAllByPath($path, $filters)
        );
    }
}
