<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class Get extends Controller
{
    public function __invoke(int $id, Request $request): JsonResponse
    {
        try {
            $json = is_string($request->query('filters')) ? $request->query('filters') : '{}';
            $filters = json_decode($json, true) ?? [];
            $insidePage = InsidePagesService::getPageById($id);
            if (! empty($filters['langcode']) && $insidePage->langcode !== $filters['langcode']) {
                throw new ModelNotFoundException();
            }

            return response()->json([
                'data' => $insidePage,
            ]);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'message' => 'Page not found.',
                'error' => 404,
            ], 404);
        }
    }
}
