<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class Display extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        $path = is_string($request->query('path')) ? $request->query('path') : '';
        $langcode = $request->user()?->langcode;
        if (! $path || ! $langcode) {
            return response()->json(['message' => 'Path not provided'], 422);
        }

        $cacheKey = InsidePagesService::getPageCacheKeyFromPath($path, $langcode);

        $page = Cache::rememberForever($cacheKey, function () use ($path, $langcode) {
            return InsidePagesService::getPublishedPageByPath($path, $langcode);
        });

        return response()->json([
            'data' => $page,
        ]);
    }
}
