<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class DeleteDraft extends Controller
{
    public function __invoke(int $id): JsonResponse
    {
        try {
            InsidePagesService::deleteDraftPageById($id);

            return response()->json(['message' => 'Draft page deleted successfully.']);
        } catch (ModelNotFoundException $e) {
            return response()->json(['message' => 'Page not found.', 'error' => 404], 404);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }
}
