<?php

namespace Inside\Content\Http\Controllers\InsidePages;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Inside\Content\Services\InsidePagesService;
use Laravel\Lumen\Routing\Controller;

class Create extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'string|max:255',
            'path' => 'required|string|max:255',
            'status' => 'nullable|boolean',
            'id' => 'nullable|integer|exists:inside_pages,id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $langcode = $request->user()?->langcode;
        if (empty($langcode)) {
            return response()->json([
                'message' => 'page not found',
                'error' => 404,
            ], 404);
        }

        try {
            $payload = $request->all();
            $payload['langcode'] = $langcode;
            $page = InsidePagesService::createOrUpdate($payload);

            return response()->json([
                'message' => $request->input('id') ? 'Page updated successfully.' : 'Page created successfully.',
                'data' => $page,
            ]);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'message' => 'Page not found.',
                'error' => 404,
            ], 404);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 403);
        }
    }
}
