<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\External;

use Exception;
use Inside\Content\Facades\Schema;
use Laravel\Lumen\Routing\Controller as BaseController;

abstract class Controller extends BaseController
{
    /**
     * @throws Exception
     */
    public function __construct()
    {
        if (! config('external_api.inside_external_api_enabled')) {
            throw new Exception('External API is disabled');
        }

        if (! config('external_api.inside_external_api_bypass_auth_external')) {
            $this->middleware('auth.external:inside');
        }
    }

    /**
     * @throws Exception
     */
    public function checkContentType(string $contentType): string
    {
        $contentType = config('external_api.custom_types')[$contentType] ?? $contentType;

        if (! in_array($contentType, array_keys(config('external_api.inside_external_api_fields')))
        || ! Schema::hasModel($contentType)) {
            throw new Exception('Invalid content type');
        }

        return $contentType;
    }
}
