<?php

namespace Inside\Content\Http\Controllers;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\Calendar;
use Inside\Content\Models\Contents\Events;
use Inside\Content\Models\Sections\Invite;
use Laravel\Lumen\Routing\Controller;

class CalendarController extends Controller
{
    public function exportCalendarEvent(Request $request): JsonResponse
    {
        if (! class_exists(Events::class)) {
            throw new Exception('Events content type is missing');
        }

        $calendarType = $request->get('type');
        $uuid = $request->get('uuid');

        $event = Events::findOrFail($uuid);
        $exportUrl = Calendar::getEventCalendarExport($calendarType, $event);

        return response()->json(['exportUrl' => $exportUrl]);
    }

    public function exportCalendarInvite(Request $request): JsonResponse
    {
        if (! class_exists(Invite::class)) {
            throw new Exception('Invite section type is missing');
        }

        $calendarType = $request->get('type');
        $uuid = $request->get('uuid');

        $invite = Invite::findOrFail($uuid);
        $exportUrl = Calendar::getInviteCalendarExport($calendarType, $invite);

        return response()->json(['exportUrl' => $exportUrl]);
    }
}
