<?php

declare(strict_types=1);

namespace Inside\Content\Http\Controllers\AdvancedTable;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Sections\AdvancedTable;
use Inside\Content\Services\AdvancedTable\Export;
use Maatwebsite\Excel\Facades\Excel;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

final class ExportController extends Controller
{
    public function __invoke(string $uuid) : JsonResponse|BinaryFileResponse
    {
        try {
            $advancedTable = AdvancedTable::query()->findOrFail($uuid);

            $jsonData = json_decode($advancedTable->advanced_table, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                return response()->json(['error' => 'Invalid JSON data in Advanced Table!'], 422);
            }

            return Excel::download(new Export($jsonData), 'exported_table_'.now()->format('Y_m_d_H_i_s').'.xlsx');
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Section Advanced Table not found!'], 403);
        } catch (\Exception $e) {
            Log::error($e->getMessage());

            return response()->json(['error' => 'An unexpected error occurred!'], 500);
        }
    }
}
