<?php

namespace Inside\Content\Helpers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

/**
 * Schema helper.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SchemaHelper
{
    /**
     * List tables prefixed with "inside_content_"
     */
    public static function listContentTables(): array
    {
        return array_unique(DB::table('information_schema.tables')
            ->where('TABLE_NAME', 'like', 'inside_content_%')
            ->where('TABLE_SCHEMA', env('DB_DATABASE'))
            ->pluck('TABLE_NAME')
            ->toArray());
    }

    /**
     * List tables prefixed with "inside_section_"
     */
    public static function listSectionTables(): array
    {
        return array_unique(DB::table('information_schema.tables')
            ->where('table_name', 'like', 'inside_section_%')
            ->where('table_schema', env('DB_DATABASE'))
            ->pluck('table_name')
            ->toArray());
    }
}
