<?php

namespace Inside\Content\Facades;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Inside\Content\Models\Content;
use Inside\Content\Services\CleanContentService;

/**
 * @method static void validate(Content $content)
 * @method static array getParentReferenceFields(Content $content)
 * @method static Collection getChildrenReferenceFields(Content $content)
 * @method static int getChildrenCount(Content $content)
 * @method static Collection getChildren(Content $content, bool $onlyParent = false)
 * @method static void clean(Content $content)
 * @method static bool shouldDeleteChildren(Content $content)
 * @method static void forceChildrenDeletion(Content $content, bool $force = false)
 */
class ContentCleaner extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return CleanContentService::class;
    }
}
