<?php

declare(strict_types=1);

namespace Inside\Content\Exceptions;

use Exception;
use Inside\Content\Models\Content;
use Inside\Content\Models\Revision;

final class RevisionCanNotRestored extends Exception
{
    public static function for(Content $content, ?Revision $restoredRevision): self
    {
        return new self(__(
            'Content :type (:id) can not restored to :restored',
            [
                'type' => class_to_type($content),
                'id' => $content->uuid ?? '<null>',
                'restored' => $restoredRevision?->version ?? 'unknown version',
            ]
        ));
    }
}
