<?php

declare(strict_types=1);

namespace Inside\Content\Exceptions;

use Exception;
use Inside\Content\Models\Content;

final class RevisionCanNotBeFound extends Exception
{
    public static function for(Content $content, ?int $version): self
    {
        return new self(__(
            'Content :type (:id) can not be found at version :version',
            [
                'type' => class_to_type($content),
                'id' => $content->uuid ?? '<null>',
                'version' => $version ?? '<unkown>',
            ]
        ));
    }
}
