<?php

namespace Inside\Content\Exceptions;

use InvalidArgumentException;

/**
 * FieldSchemaNotFoundException
 *
 * The field dooes not exist
 *
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
final class FieldSchemaNotFoundException extends InvalidArgumentException
{
    public static function named(string $modelName, string $fieldName): self
    {
        return new self("There is no field named `{$fieldName}` in model `{$modelName}`.");
    }
}
