<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Someone wished an happy birthday to someone else
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SeniorityAnniversaryWishesSendEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * $fromUser wished an happy birthday to $toUser
     */
    public function __construct(
        public User $fromUser,
        public User $toUser
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.seniority.anniversary.'.$this->toUser->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside.seniority.anniversary.wished';
    }
}
