<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

class ExportCompletedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * ExportCompletedEvent constructor.
     */
    public function __construct(
        public ?string $disk,
        public string $path,
        public ?User $user
    ) {
    }

    public function broadcastOn(): ?PrivateChannel
    {
        if (is_null($this->user)) {
            return null;
        }

        return new PrivateChannel('inside.exports.'.$this->user->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside.export.completed';
    }

    public function broadcastWith(): array
    {
        return ['path' => Storage::disk($this->disk)->url($this->path)];
    }
}
