<?php

namespace Inside\Content\Events;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content synched event.
 *
 * @author   Maecia <technique@maecia.com>
 * @link     http://www.maecia.com/
 */
class ContentSynchedEvent
{
    use Dispatchable;

    public ?User $user;

    /**
     * Create a new content updated event instance.
     */
    public function __construct(
        public Content $model,
        public string $fieldName,
        public Collection $original,
        public Collection $dirty
    ) {
        /** @var ?User $user */
        $user = Auth::user();
        $this->user = $user;
    }
}
