<?php

namespace Inside\Content\Events;

use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content saved event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentSavedEvent
{
    use SerializesModels;
    use Dispatchable;

    /**
     * Create a new content created event instance.
     */
    public function __construct(
        public Content $model
    ) {
    }
}
