<?php

namespace Inside\Content\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Events\Dispatchable;

/**
 * Content processed event. Meaning it has been created, pivoted etc...
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentProcessedEvent
{
    use SerializesModels;
    use Dispatchable;

    public ?User $user;

    /**
     * Create a new content created event instance.
     */
    public function __construct(
        public Content $model
    ) {
        /** @var ?User $user */
        $user = Auth::user();
        $this->user = $user;
    }
}
