<?php

namespace Inside\Content\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Comments;
use Inside\Events\Dispatchable;

/**
 * Comment pivot removed event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CommentDeletedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * Create a new event instance.
     *
     * @param Comments $comment The comment entity
     * @param Content  $parent  The parent entity from which the comment was removed
     */
    public function __construct(
    public Comments $comment,
    public Content $parent
  ) {
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return PrivateChannel
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_content.'.class_to_type($this->parent).'.'.$this->parent->uuid);
    }

    /**
     * Get the name of the broadcast event.
     *
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside_content.comments.deleted';
    }
}
