<?php

namespace Inside\Content\Doctrine\DBAL\Types;

use Doctrine\DBAL\Exception as DBALException;
use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Types\Type;

class TimestampType extends Type
{
    public function getName(): string
    {
        return 'timestamp';
    }

    /**
     * @throws DBALException
     */
    public function getSQLDeclaration(array $column, AbstractPlatform $platform): string
    {
        switch ($name = $platform->getName()) {
            case 'mysql':
                return $this->getMySqlPlatformSQLDeclaration($column);
            default:
                throw new DBALException('Inside does not support platform: '.$name);
        }
    }

    protected function getMysqlPlatformSQLDeclaration(array $fieldDeclaration): string
    {
        $columnType = 'TIMESTAMP';

        if ($fieldDeclaration['precision']) {
            $columnType = 'TIMESTAMP('.$fieldDeclaration['precision'].')';
        }

        $notNull = $fieldDeclaration['notnull'] ?? false;

        if (! $notNull) {
            return $columnType.' NULL';
        }

        return $columnType;
    }
}
