<?php

declare(strict_types=1);

namespace Inside\Content\DTO;

use Illuminate\Support\Collection;

final class ContentOrderedItemDTO
{
    public Collection $children;

    public string $orderField;

    public function __construct(
        public string $contentType,
        public string $uuid,
        public ?string $parentField = null,
        ?string $orderField = null,
        array | Collection $children = [],
    ) {
        $this->children = collect($children);
        $this->orderField = $orderField ?? 'weight';
    }

    public static function from(array $items): Collection
    {
        return collect($items)
            ->map(fn (array $item) => new self(
                contentType: $item['content_type'],
                uuid: $item['uuid'],
                parentField: $item['parent_field'] ?? null,
                orderField: $item['order_field'] ?? null,
                children: self::from($item['children'] ?? [])
            ))
            ->values();
    }
}
