<?php

declare(strict_types=1);

namespace Inside\Content\Contracts;

use Closure;
use Inside\Content\Models\Content;
use Inside\Content\Models\Revision;
use Inside\Content\Models\Section;
use Inside\Content\Models\WysiwygImage;

interface RevisionService
{
    public function isEnabled(Content $content): bool;

    public function withoutWorkflow(Closure $callback): mixed;

    public function enableRevision(): void;

    public function disableRevision(): void;

    public function canBeRestored(Content $content, int $version): bool;

    public function transformRevisionToFrontView(Revision $revision): array;

    public function transformRevisionToBridgeContentData(Revision $revision): array;

    public function transformContentFieldsWithTransformer(
        Content|Section $content,
        Revision $revision,
        string $transformer,
        ?Content $root = null
    ): array;

    public function findRevisionImage(string $type, string $id, int $version, string $imagePath): ?WysiwygImage;

    public function findRevisionFile(string $type, string $id, int $version, string $filePath): ?string;

    public function revisionMiddleware(string|array $middleware): self;

    public function restoreMiddleware(string|array $middleware): self;

    public function getSupportedContentTypes(): array;

    public function createNewRevision(Content $content): void;

    public function restoreFromRevision(Content $content, Revision $revision): bool;

    public function cleanupRevisionBeforeDeletion(Revision $revision): void;
}
