<?php

declare(strict_types=1);

namespace Inside\Content\Contracts;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Inside\Content\Models\Content;
use Inside\Content\Models\Section;

interface QueryHelper
{
    public function find(string $type, string $uuid): ?Content;

    public function findOrFail(string $type, string $uuid): Content|Section;

    public function all(string $type): Collection;

    public function extractFieldsInputFromRequest(Request $request): array;

    public function extractFiltersInputFromRequest(Request $request): array;

    public function getAndRemoveQuery(Request &$request, string $key): mixed;

    public function removeInputFromRequest(Request $request, string $group, string $keyName): Request;

    public function requestBoolean(string $value): bool;

    public function addMissings(string $type, array $data, bool $creation = true): array;

    public function castAttributes(string $type, array $data): array;

    public function getAttributeNames(string $type, ?string $locale = null): array;

    public function getOperatorFromString(string $operator): ?string;
}
