<?php

namespace Inside\Content\Console;

use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Inside\Console\Command;
use Inside\Content\Contracts\WysiwygImageService;
use Inside\Content\Models\Sections\Text;

class RepairWysiwygImagesCommand extends Command
{
    public function __construct(protected WysiwygImageService $wysiwygImageService)
    {
        parent::__construct();
    }

    /**
     * @var string
     */
    protected $name = 'inside:wysiwyg-images:repair';

    /**
     * @var string
     */
    protected $signature = 'inside:wysiwyg-images:repair';

    /**
     * @var string
     */
    protected $description = 'Fix storage url of images in wysiwyg';

    public function handle(): void
    {
        $storage = Storage::disk('local');
        $sections = Text::where('body', 'LIKE', '%src="/storage/%')->get();

        $pattern = '/src="\/storage\/app\/([^"]+)"/';
        $this->writeln('<fg=yellow>Find '.$sections->count().' sections contains wrong resources url.</>');
        $sections->each(function ($section) use ($storage, $pattern) {
            $updateSections = false;
            $htmlBody = $section->body;
            preg_match_all($pattern, $htmlBody, $matches);

            collect($matches[1])->each(function ($wrongPath) use ($storage, &$htmlBody, &$updateSections) {
                if (! $storage->exists($wrongPath)) {
                    return;
                }

                $updateSections = true;
                $file = new UploadedFile(
                    $storage->path($wrongPath),
                    basename($wrongPath),
                    $storage->mimeType($wrongPath)
                );

                $upload = $this->wysiwygImageService->upload($file);
                $htmlBody = str_replace(
                    '/storage/app/'.$wrongPath,
                    env('APP_URL').$upload,
                    $htmlBody
                );
            });

            if ($updateSections) {
                $content = call_user_func($section->sectionable_type.'::find', $section->sectionable_uuid);
                $section->update([
                    'body' => $htmlBody,
                ]);
                $this->writeln('<fg=yellow>'.$content->title.' section text updated ✔</>');
            }
        });
    }
}
