<?php

namespace Inside\Content\Console;

use Inside\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

/**
 * Class RepairLangcodeField
 */
class RepairPublicationFields extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:fields:repair';

    /**
     * @var string
     */
    protected $signature = 'inside:fields:repair';

    /**
     * @var string
     */
    protected $description = 'Réparation des champs "système" ( langue, auteur, date de création ) qui auraient disparu';

    /**
     * Handle index command
     *
     * @return void
     * @throws \Exception
     */
    public function handle(): void
    {
        if (count(list_languages()) <= 1) {
            $this->error('Cette instante est monolingue.');
        }
        $bridge = new BridgeContentType($this->getOutput());
        foreach (Schema::getContentTypes() as $type) {
            if (in_array($type, ['comments'])) {
                continue;
            }
            $options = Schema::getModelOptions($type);

            // Repair langcode field
            if ($options['translatable'] && Schema::hasField($type, 'langcode')) {
                $langcodeFieldOptions = Schema::getFieldOptions($type, 'langcode');
                if (! $langcodeFieldOptions['displayed']) {
                    $this->info(
                        'Réparation du champ <fg=magenta>langue</fg=magenta> du type de contenu <fg=cyan>'.$type
                        .'</fg=cyan>'
                    );
                    $bridge->changeFieldFormOptions($type, 'langcode', true, 'group_advanced_options');
                }
            }

            // Repair published
            if (Schema::hasField($type, 'status')) {
                $this->info(
                    'Réparation du champ <fg=magenta>publié</fg=magenta> du type de contenu <fg=cyan>'.$type
                    .'</fg=cyan>'
                );
                $bridge->changeFieldFormOptions($type, 'status', true, 'group_options');
            }

            // Repair created_at
            if (Schema::hasField($type, 'created_at')) {
                $this->info(
                    'Réparation du champ <fg=magenta>créé le</fg=magenta> du type de contenu <fg=cyan>'.$type
                    .'</fg=cyan>'
                );
                $bridge->changeFieldFormOptions($type, 'created_at', true, 'group_options');
            }

            // Repair author
            if (Schema::hasField($type, 'authors')) {
                $this->info(
                    'Réparation du champ <fg=magenta>créé par</fg=magenta> du type de contenu <fg=cyan>'.$type
                    .'</fg=cyan>'
                );
                $bridge->changeFieldFormOptions($type, 'authors', true, 'group_options');
            }
        }
    }
}
