<?php

namespace Inside\Content\Console;

use Illuminate\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Host\Actions\RepairFieldExtensions;
use Inside\Host\Actions\RepairFieldMaxFilesize;
use Inside\Host\Bridge\BridgeContentType;

class RepairFileExtensionsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:repair:file-extensions';

    /**
     * @var string
     */
    protected $signature = 'inside:repair:file-extensions';

    /**
     * @var string
     */
    protected $description = 'Réenregistrement des champs video Drupal pour remettre par défaut les extensions';

    protected BridgeContentType $bridge;

    public function handle(): void
    {
        $this->bridge = new BridgeContentType();
        $action = new RepairFieldExtensions();

        collect(Schema::getAllFieldsListingOfType('file'))
            ->reject(fn (array $attributes, string $type) => $attributes === ['video'] || str($type)->contains('video'))
            ->transform(fn (array $attributes, $contentType) => collect($attributes)->crossJoin($contentType))
            ->flatten(1)
            ->each(fn (array $toUpdate) => $this->getOutput()->writeln(
                $action->repair(
                    type: $toUpdate[1],
                    field: $toUpdate[0],
                    storage: Schema::isContentType($toUpdate[1]) ? 'node' : 'paragraph',
                    extensions: config('generator.files.file_extensions')
                )
            ));
    }
}
