<?php

namespace Inside\Content\Console\Paragraphs;

use Inside\Console\Command;
use Inside\Content\Services\ConfigurationGenerator\ParagraphsGenerator;

class ListUnavailableParagraphs extends Command
{
    protected $signature = 'inside:paragraph:unavailable';

    protected $description = 'List unavailable paragraphs on this intranet';

    public function handle(): void
    {
        $list = collect(ParagraphsGenerator::load()->getUnvailable())
            ->keys()
            ->map(fn (string $name) => [
                'name' => $name,
                'to enabled' => 'inside:paragraph:enable '.$name,
            ]);

        if ($list->isEmpty()) {
            $this->info('All paragraphs are available!');
        } else {
            $this->table(['Name', 'To enabled'], $list);
        }

        $this->writeln("\n");
    }
}
