<?php

namespace Inside\Content\Console\Paragraphs;

use Inside\Console\Command;

class ImportConfigurations extends Command
{
    protected $signature = 'inside:paragraph:config:import';

    protected $description = 'Import configuration for available paragraphs througt Drush';

    public function handle(): void
    {
        $command = collect([
            'php',
            '-d memory_limit=-1',
            cms_base_path('vendor/bin/drush'),
            'config:import',
            '--partial',
            '--debug',
            '--yes',
            '--source='.config('generator.config.output'),
        ])->join(' ');

        exec(windows_os() ? str_replace('/', '\\', $command) : $command);
    }
}
