<?php

declare(strict_types=1);

namespace Inside\Content\Console;

use Inside\Console\Command;
use Inside\Content\Jobs\AddRevisionOnExistingContentsIfNeeded;

final class InitRevisionCommand extends Command
{
    protected $name = 'inside:revision:init';

    protected $signature = 'inside:revision:init';

    protected $description = 'Initialise les premières versions de chaque contenu.';

    public function handle(): int
    {
        $this->getOutput()->title('Initialisation des premières versions des contenus.');

        AddRevisionOnExistingContentsIfNeeded::dispatchNow($this->getOutput());

        $this->getOutput()->success('Initialisation terminées!');

        $this->getOutput()->warning('La création des versions va désormais se réaliser en tâche de fond et peut prendre un certain temps en fonction du nombre de contenus...');

        return Command::SUCCESS;
    }
}
