<?php

namespace Inside\Content\Console;

use Illuminate\Support\Facades\File;
use Inside\Console\Command;
use Inside\Content\Facades\ContentImporter;
use Inside\Content\Services\ContentImportService;

class ImportContentFromCsvCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:contents:import {--reverse}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import contents from csv file';

    /**
     * Importation config
     *
     * @var array
     */
    protected $config;

    /**
     * InsideImport constructor.
     */
    public function __construct(private ContentImportService $importService)
    {
        parent::__construct();
    }

    public function handle(): void
    {
        $reverse = $this->option('reverse');
        $config = config('importable_content_types');

        $allowedTypes = $config['allowed_content_types'] ?? [];

        if (empty($allowedTypes)) {
            $this->error('Aucun type de contenu disponible dans la configuration.');

            return;
        }

        $this->info('Types de contenus disponibles :');
        $index = 0;
        foreach ($allowedTypes as $type) {
            $this->line('  ['.$index++."] $type");
        }

        $allowedTypesKeys = array_keys($allowedTypes);
        $choice = $this->ask('Veuillez saisir le numéro du type de contenu à importer');

        // Validation
        if (! isset($allowedTypesKeys[$choice])) {
            $this->error('Choix invalide. Abandon de l’import.');

            return;
        }

        $selectedType = $allowedTypesKeys[$choice];
        $this->warn("Pour importer les contenus, veuillez déposer un fichier nommé '$selectedType.csv' dans /storage/app/import avant d'appuyer sur la touche Entre");

        $this->ask('Entrer !');

        $file = $selectedType.'.csv';

        try {
            $this->importService->setReverseImportOrder($reverse)
                ->setConfig($config)
                ->setOutput($this->output)
                ->execute($file);

            $this->info("Contenus importés depuis le fichier : $file");
        } catch (\Exception $exception) {
            $this->error($exception->getMessage());
        }
    }
}
