<?php

namespace Inside\Content\Console;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\File;
use Inside\Console\Command;
use Inside\Content\Facades\Schema;
use Inside\Content\Services\GedExportService;
use Inside\Host\Bridge\BridgeContentType;
use ReflectionClass;

/**
 * Class ExportGedCommand
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ExportGedCommand extends Command
{
    protected $name = 'inside:ged:export';

    protected $signature = 'inside:ged:export {to?} {--folder=}';

    protected $description = 'Export ged directories and files';

    public function __construct(private GedExportService $gedExportService)
    {
        parent::__construct();
    }

    public function handle(): void
    {
        /**
         * @var ?string $rootFolder
         */
        $rootFolder = $this->option('folder');

        /**
         * @var string $exportPath
         */
        $exportPath = $this->argument('to') ?? 'ged_export';

        $this->info('Starting export...');

        $this->gedExportService
            ->setExportPath($exportPath)
            ->setRootFolder($rootFolder)
            ->execute();

        $this->info('Export completed successfully!');
    }
}
