<?php

namespace Inside\Content\Console;

use Inside\Console\Command;
use Inside\Content\Facades\ContentExporter;

class ExportContentCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:export {config} {--langcode=} {--format=} {--silent}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Exporter des contenus depuis inside';

    /**
     * Importation config
     *
     * @var array
     */
    protected $config;

    /**
     * InsideImport constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->config = config('imports');
    }

    public function handle(): void
    {
        /** @var string $configName */
        $configName = $this->argument('config');
        /** @var string $langCode */
        $langCode = $this->option('langcode');
        $format = $this->option('format');
        $silent = $this->option('silent');

        $supported = array_keys($this->config);

        // Check required parameters
        if (! in_array($configName, $supported)) {
            $this->error(
                'La configuration ['.$configName.'] n\'est pas supporté. Seules les configurations ['.implode(
                    ', ',
                    $supported
                ).'] peuvent être utilisée'.(count($supported) > 1 ? 's' : '').'.'
            );

            return;
        }

        $config = $this->config[$configName];

        $config['silent'] = $silent;
        $config['langcode'] = $langCode;
        $config['input'] = [];
        $order = 0;
        $defaultExports = $config['default_exports'] ?? null;
        if ($defaultExports === null) {
            $fields = $config['fields'];
            $config['fields'] = [];
            foreach ($fields as $key => $field) {
                $config['fields'][] = [$key => ['order' => $order++]];
            }
            $config['fields'] = $fields;
        } else {
            $config['fields'] = $defaultExports;
        }

        if ($langCode != null) {
            $langCode = explode(',', $langCode);
            $config['filters'] = [
                'langcode:in' => $langCode,
            ];
        }

        $driver = $config['format']['driver'] ?? 'csv';
        if ($format) {
            $driver = $format;
        }

        ContentExporter::export($driver, $config, ! $silent ? $this->getOutput() : null);
    }
}
