<?php

namespace Inside\Content\Console;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Inside\Console\Command;
use Inside\Content\Models\Contents\Users;

class CleanUsersProfileImageCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:profile-image:clean';

    /**
     * @var string
     */
    protected $signature = 'inside:profile:image:clean';

    /**
     * @var string
     */
    protected $description = 'Remove profile image of accounts that have been deactivated for 90 days ago';

    /**
     * Handle index command
     */
    public function handle(): void
    {
        $daysBeforeDeletingProfileImage = (int) config('contents.anonymous_users.days_before_deleting_image');
        $dateFromPassedDays = Carbon::now()->subDays($daysBeforeDeletingProfileImage)->toDateTimeString();
        $users = Users::where('status', 0)
            ->whereDate('updated_at', '<', $dateFromPassedDays)
            ->whereNotNull('image')
            ->get();

        foreach ($users as $user) {
            $imagePath = $user->image;
            if (Storage::disk('local')->exists($imagePath)) {
                Storage::delete($imagePath);
            }

            Users::where('uuid', $user->uuid)->update(['image' => null]);

            Log::info("[Delete Profile Image] [UUID:$user->uuid] [imagePath:$imagePath]");
        }
    }
}
