<?php

namespace Inside\Content\Chat\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Chat\Models\Chat;
use Inside\Events\Dispatchable;

/**
 * Class ChatEvent
 */
class ChatEvent implements ShouldBroadcast
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public function __construct(
        public Chat $chat
    ) {
    }

    public function broadcastOn(): PresenceChannel
    {
        return new PresenceChannel('inside.chat');
    }

    public function broadcastAs(): string
    {
        return 'inside.chat.message';
    }

    /**
     * @return array
     */
    public function broadcastWith()
    {
        $this->chat->load('user.information');

        return [
            'chat' => $this->chat,
        ];
    }
}
