<?php

namespace Inside\Content\Calendars;

use Inside\Content\Contracts\CalendarInterface;

final class Yahoo implements CalendarInterface
{
    public function generate(string $title, ?string $location, int $startDate, ?int $endDate, ?string $description, ?string $url): string
    {
        $start = date('Ymd\THis\Z', $startDate);
        $end = $endDate ? date('Ymd\THis\Z', $endDate) : null;

        if ($url) {
            $desc = "<a href=\"$url\">$url</a><p>$description</p>";
        } else {
            $desc = $description;
        }

        $query = http_build_query([
            'v' => 60,
            'title' => $title,
            'in_loc' => $location,
            'st' => $start,
            'et' => $end,
            'desc' => $desc,
        ]);

        return "https://calendar.yahoo.com/?$query";
    }
}
