<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;

class FilePathSeeder extends Seeder
{
    public function run()
    {
        $fields = \Inside\Content\Models\Field::whereIn('type', ['file', 'image'])->get();

        foreach ($fields as $field) {
            $model = $field->model;
            $contents = call_user_func($model->class.'::all');

            $this->command->info('Field '.$model->class.' - '.$field->name);

            foreach ($contents as $content) {
                if ($content->{$field->name}) {
                    $content->unsetEventDispatcher();
                    $content->{$field->name} = str_replace('/sites/default/files/public/', '', $content->{$field->name});
                    $content->{$field->name} = str_replace('sites/default/files/public/', '', $content->{$field->name});
                    $content->{$field->name} = str_replace(':./', '', $content->{$field->name});
                    $content->{$field->name} = str_replace(':.', '', $content->{$field->name});
                    $content->save();
                }
            }
        }
        $this->command->info('No more anonymous user - Done.');
    }
}
