<?php

namespace Inside\Content\Seeders;

use Illuminate\Database\Seeder;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\AlphabetBooksCategories;
use Inside\Host\Bridge\BridgeContent;

class AlphabetCategoriesSeeder extends Seeder
{
    public function run()
    {
        if (! Schema::hasModel('alphabet_books_categories')) {
            throw new \Exception('alphabet_books_categories content type has to be created to run this seeder');
        }

        $bridgeContent = new BridgeContent();
        foreach (range('A', 'Z') as $alphabetTitle) {
            $locale = config('app.locale');
            $uuid = $bridgeContent->contentInsert('alphabet_books_categories', [
                'title' => $alphabetTitle,
                'langcode' => $locale,
                'type' => 'node',
                'bundle' => 'alphabet_books_categories',
            ], true, true);
            $content = AlphabetBooksCategories::find($uuid);

            collect(list_languages())
                ->diff([$locale])
                ->each(function ($language) use ($bridgeContent, $alphabetTitle, $content) {
                    $bridgeContent->contentInsert('alphabet_books_categories', [
                        'title' => $alphabetTitle,
                        'uuid_host' => $content->uuid_host,
                        'langcode' => $language,
                        'type' => 'node',
                        'bundle' => 'alphabet_books_categories',
                    ], true, true);
                });
        }

        $this->command->info('Alphabet categories created !');
    }
}
