<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'slide_video',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'fr' => 'Diapositive vidéo',
            'en' => 'Video slide',
            'de' => 'Video-Folie',
            'es' => 'Diapositiva de vídeo',
            'nl' => 'Video-dia',
            'pt' => 'Slide de vídeo',
        ],
    ],
    'fields' => [
        [
            'name' => 'title',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Légende de la vidéo',
                'en' => 'Video caption',
                'de' => 'Videountertitel',
                'es' => 'Leyenda del vídeo',
                'nl' => 'Bijschrift video',
                'pt' => 'Legenda do vídeo',
            ],
            'description' => [],
            'widget'       => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'         => BridgeContentType::TEXT_FIELD,
            'settings'     => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name' => 'file',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Diapositive vidéo',
                'en' => 'Video slide',
                'de' => 'Video-Folie',
                'es' => 'Diapositiva de vídeo',
                'nl' => 'Video-dia',
                'pt' => 'Slide de vídeo',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
                'file_extensions' => 'mp4 avi mov webm',
            ],
        ],
    ],
];
