<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'slide_image',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'fr' => 'Diapositive image',
            'en' => 'Image slide',
            'de' => 'Bild-Folie',
            'es' => 'Diapositiva de imagen',
            'nl' => 'Afbeelding-dia',
            'pt' => 'Slide de imagem',
        ],
    ],
    'fields' => [
        [
            'name' => 'title',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Légende de l’image',
                'en' => 'Image caption',
                'de' => 'Bildunterschrift',
                'es' => 'Leyenda de la imagen',
                'nl' => 'Bijschrift afbeelding',
                'pt' => 'Legenda da imagem',
            ],
            'description' => [],
            'widget'       => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'         => BridgeContentType::TEXT_FIELD,
            'settings'     => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => true,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Diapositive image',
                'en' => 'Image slide',
                'de' => 'Bild-Folie',
                'es' => 'Diapositiva de imagen',
                'nl' => 'Afbeelding-dia',
                'pt' => 'Slide de imagem',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
