<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name'  => 'button',
        'title' => [
            'fr' => 'Bouton',
            'en' => 'Button',
        ],
    ],
    'fields'  => [
        // Text
        [
            'name'         => 'button_text',
            'searchable'   => false,
            'translatable' => false,
            'search_result_field' => false,
            'default'      => '',
            'required'     => true,
            'weight'       => 0,
            'title'        => [
                'fr' => 'Texte du lien',
                'en' => 'Link text',
            ],
            'description'  => [
                'fr' => '',
                'en' => '',
            ],
            'widget'       => [
                'type'     => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type'         => BridgeContentType::TEXT_FIELD,
            'settings'     => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        // Link
        [
            'name'                => 'button_uri',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => [],
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Url du lien',
                'en' => 'Link url',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size'           => 60,
                    'placeholder'    => '',
                ],
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        // Alignment
        [
            'name'                => 'button_alignment',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => [],
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Alignement',
                'en' => 'Alignement',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [
                ],
            ],
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'settings'            => [
                'cardinality' => 1,
                'allowed_values' => [
                    'left' => [
                        'fr' => 'Ferré à gauche',
                        'en' => 'Left',
                    ],
                    'center' => [
                        'fr' => 'Centré',
                        'en' => 'Center',
                    ],
                    'right' => [
                        'fr' => 'Ferré à droite',
                        'en' => 'Right',
                    ],
                ],
            ],
        ],
        // Couleur
        [
            'name'                => 'button_color',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => '#ffffff',
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Couleur',
                'en' => 'Color',
            ],
            'description'         => [],
            'widget'              => [
                'type'     => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [
                ],
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'cardinality' => 1,
                'allowed_values' => [
                    'left' => [
                        'fr' => 'Ferré à gauche',
                        'en' => 'Left',
                    ],
                    'center' => [
                        'fr' => 'Centré',
                        'en' => 'Center',
                    ],
                    'right' => [
                        'fr' => 'Ferré à droite',
                        'en' => 'Right',
                    ],
                ],
            ],
        ],
    ],
];
