<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Migrations\CreateContentTypes;

class MakeAuthorIdColumnOnSectionsNullable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach (InsideSchema::getSectionTypes() as $type) {
            $table = section_type_to_table($type);

            Schema::table($table, function (Blueprint $table) {
                $table->string('author_id', 36)->nullable()->change();
            });
        }

        $this->finishUp();
    }
}
