<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddColorFieldsForNewsCategoriesAndBranchesAndGroups extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        if (InsideSchema::hasModel('news_categories')) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'news_categories',
                fieldName: 'color',
                options: [
                    'name' => 'color',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => true,
                    'required' => false,
                    'weight' => 2,
                    'title' => [
                        'fr' => 'Couleur',
                        'en' => 'Color',
                        'es' => 'Color',
                        'de' => 'Farbe',
                        'pt' => 'Cor',
                        'nl' => 'Kleur',
                    ],
                    'description' => [],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                        'settings' => [
                            'size' => 60,
                            'placeholder' => '',
                        ],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                    'default' => setting('general', 'color_primary'),
                ]
            );
            type_to_class('news_categories')::all()->each(function ($category) use ($bridgeContent) {
                if (empty($category->color)) {
                    $bridgeContent->contentUpdate(
                       type: 'news_categories',
                       data: [
                           'uuid_host' => $category->uuid_host,
                           'color' => setting('general', 'color_primary'),
                       ],
                   );
                }
            });
        }

        if (InsideSchema::hasModel('branches_and_groups')) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'branches_and_groups',
                fieldName: 'color',
                options: [
                    'name' => 'color',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => true,
                    'required' => false,
                    'weight' => 2,
                    'title' => [
                        'fr' => 'Couleur',
                        'en' => 'Color',
                        'es' => 'Color',
                        'de' => 'Farbe',
                        'pt' => 'Cor',
                        'nl' => 'Kleur',
                    ],
                    'description' => [],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                        'settings' => [
                            'size' => 60,
                            'placeholder' => '',
                        ],
                        'weight' => 2,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                    'default' => setting('general', 'color_primary'),
                ]
            );
            type_to_class('branches_and_groups')::all()->each(function ($category) use ($bridgeContent) {
                if (empty($category->color)) {
                    $bridgeContent->contentUpdate(
                        type: 'branches_and_groups',
                        data: [
                            'uuid_host' => $category->uuid_host,
                            'color' => setting('general', 'color_primary'),
                        ],
                    );
                }
            });
        }
    }
}
