<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class MakeFieldsTranslatableForPostings extends Migration
{
    public function up(): void
    {
        if (
            ! InsideSchema::hasContentType('postings')
        ) {
            return;
        }

        $bridge = new BridgeContentType();

        if (InsideSchema::hasField('postings', 'summary')) {
            $bridge->updateFieldOptions(
                type: 'postings',
                fieldName: 'summary',
                options: [
                    'translatable' => true,
                ]
            );
        }

        if (InsideSchema::hasField('postings', 'image')) {
            $bridge->updateFieldOptions(
                type: 'postings',
                fieldName: 'image',
                options: [
                    'translatable' => true,
                ]
            );
        }

        if (InsideSchema::hasField('postings', 'postings_location')) {
            $bridge->updateFieldOptions(
                type: 'postings',
                fieldName: 'postings_location',
                options: [
                    'translatable' => true,
                ]
            );
        }

        if (InsideSchema::hasField('postings', 'content')) {
            $bridge->updateFieldOptions(
                type: 'postings',
                fieldName: 'content',
                options: [
                    'translatable' => true,
                ]
            );
        }
    }
}
