<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;

class FixTranslationForTabsType extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasModel('tabs') ||
            ! InsideSchema::hasField('tabs', 'tabs_spaces')) {
            return;
        }

        $translations = [
            'fr' => 'Espace à onglets',
            'en' => 'Tabbed space',
            'nl' => 'Ruimte met tabbladen',
            'pt' => 'Espaço com guias',
            'es' => 'Espacio con pestañas',
            'de' => 'Leerzeichen mit Tabs',
        ];

        InsideSchema::updateFieldOption('tabs', 'tabs_spaces', 'title', $translations);
    }
}
