<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class MakeIntroductionFieldUnrequiredForMediaViewer extends Migration
{
    public function up(): void
    {

        if (
            ! InsideSchema::hasContentType('media_viewer') ||
            ! InsideSchema::hasField('media_viewer', 'chapo')
        ) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->updateFieldOptions(
            type: 'media_viewer',
            fieldName: 'chapo',
            options: [
                'required' => false,
            ]
        );
    }
}
