<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class MakeChapoNotRequiredForPages extends Migration
{
    public function up(): void
    {
        if (
            ! InsideSchema::hasContentType('pages') ||
            ! InsideSchema::hasField('pages', 'chapo')
        ) {
            return;
        }

        $bridge = new BridgeContentType();
        $bridge->updateFieldOptions(
            type: 'pages',
            fieldName: 'chapo',
            options: [
                'required' => false,
            ]
        );
    }
}
