<?php

use Drupal\field\Entity\FieldStorageConfig;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AlterDefaultFileOnComments extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (! Schema::hasContentType('comments') ||
            Schema::getFieldOptions('comments', 'file')['cardinality'] === 1) {
            return;
        }

        // @phpstan-ignore-next-line
        $fieldStorage = FieldStorageConfig::loadByName('comment', 'field_file');
        $fieldStorage->setCardinality(1);
        $fieldStorage->save();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'comments',
            fieldName: 'file',
            options: [
                'name' => 'file',
                'default' => null,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            entityTypeId: 'comment',
        );

        Artisan::call('models:rebuild');
    }
}
