<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Contents\ImageStyles;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Support\Str;

class AddTopFooterImageStyle extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (DB::table('migrations')
            ->where('migration', '2025_09_01_000000_add_new_image_style_and_apply')
            ->exists()) {
            return;
        }

        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $langcode = config('app.locale', 'fr');

        $this->getConsole()->writeln('Langue du site détecté : ['.$langcode.']');

        $bridge->contentInsert('image_styles', [
            'type' => 'node',
            'bundle' => 'image_styles',
            'langcode' => $langcode,
            'title' => 'banner_top_footer_home',
            'width' => 1920,
            'height' => 70,
            'optimisation' => true,
            'optimisation_ratio' => 80,
            'resizable' => false,
        ]);

        $styles = ImageStyles::pluck('title')->all();
        $styles[] = 'banner_top_footer_home';

        foreach (InsideSchema::getAllFieldsListingOfType('image') as $type => $fields) {
            if (Str::endsWith($type, '_menus')) {
                continue;
            }
            $this->getConsole()->writeln(
                'Mise-à-jour du <fg=blue>'.(InsideSchema::isSectionType($type) ? 'paragraphe' : 'contenu')
                .'</> <fg=cyan>'.$type.'</>'
            );
            foreach ($fields as $fieldName) {
                try {
                    $this->getConsole()->write('Ajout du nouveau style au champ <fg=magenta>'.$fieldName.'</> du type <fg=magenta>'.$type.'</>');
                    $bridgeContentType->updateFieldOptions(
                        $type,
                        $fieldName,
                        [
                            'type'    => BridgeContentType::IMAGE_FIELD,
                            'special' => [
                                'image_styles' => $styles,
                            ],
                        ]
                    );
                    $this->getConsole()->writeln(' <fg=green>✔</fg=green>');
                } catch (Throwable $e) {
                    $this->getConsole()->writeln(' <fg=red>✘</fg=red>');
                    $this->getConsole()->writeln('<fg=red;bg=white>'.$e->getMessage().'</>');
                    continue;
                }
            }
            $this->getConsole()->writeln('<fg=yellow>'.str_repeat('-', 80).'</>');
        }
        $this->getConsole()->writeln('<fg=green>Démarrage de la génération des images en tâche de fond </>');
        $this->call('inside:images:generate');
    }

    public function down(): void
    {
    }
}
