<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroduceFieldInSimplePage extends Migration
{
    public function up(): void
    {
        if (InsideSchema::hasField('pages', 'chapo')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'pages',
            fieldName: 'chapo',
            options: [
                'name' => 'chapo',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'nl' => 'Inleiding',
                    'de' => 'Einführung',
                    'pt' => 'Introdução',
                ],
                'description' => [
                    'fr' => 'L\'introduction remonte sur les pages de listing d\'actualité et n\'est pas dupliquée dans votre contenu',
                    'en' => 'The introduction goes up on the news listing pages and is not duplicated in your content',
                    'es' => 'La introducción sube en las páginas de listado de noticias y no se duplica en su contenido',
                    'nl' => 'De inleiding komt op de nieuwslijstpagina\'s en wordt niet gedupliceerd in uw inhoud',
                    'de' => 'Die Einführung wird auf den Nachrichtenlisten-Seiten nach oben verschoben und nicht in Ihrem Inhalt dupliziert',
                    'pt' => 'A introdução sobe nas páginas de listagem de notícias e não é duplicada em seu conteúdo',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 1
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'pages',
            fieldName: 'content',
            options: [
                'name' => 'content',
                'weight' => 2,
                'widget' => [
                    'type' => BridgeContentType::SECTION_WIDGET,
                    'settings' => [
                        'title' => 'Paragraphe',
                        'title_plural' => 'Paragraphes',
                        'edit_mode' => 'open',
                        'add_mode' => 'dropdown',
                        'form_display_mode' => 'default',
                        'default_paragraph_type' => '',
                    ],
                    'weight' => 2,
                ],
            ],
            weight: 2
        );
    }
}
