<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class HideFlashNewsTitle extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::hasModel('flash_news')) {
            return;
        }
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            type: 'flash_news',
            fieldName: 'hide_title',
            entityTypeId: 'node',
            options: [
                'name' => 'hide_title',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Ne pas afficher le titre',
                    'en' => 'Do not display the title',
                    'es' => 'No mostrar el título',
                    'de' => 'Titel nicht anzeigen',
                    'pt' => 'Não exibir o título',
                    'nl' => 'Titel niet weergeven',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 2
        );
    }
}
